/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.models.ICustomDamageModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockBreakAnimationClientHandler
implements ISelectiveResourceReloadListener {
    public static final BlockBreakAnimationClientHandler instance = new BlockBreakAnimationClientHandler(Minecraft.func_71410_x());
    private static final Map<Integer, DestroyBlockProgress> damagedBranches = new ConcurrentHashMap<Integer, DestroyBlockProgress>();
    private int tickCounter = 0;
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];
    static Method preRenderMethod = ReflectionHelper.findMethod(RenderGlobal.class, (String)"preRenderDamagedBlocks", (String)"func_180443_s", (Class[])new Class[0]);
    static Method postRenderMethod;

    private BlockBreakAnimationClientHandler(Minecraft mc) {
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    @SubscribeEvent
    public void onPlayerJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerSP && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_145782_y() == event.getEntity().func_145782_y()) {
            event.getWorld().func_72848_b((IWorldEventListener)Minecraft.func_71410_x().field_71438_f);
            List listeners = (List)ReflectionHelper.getPrivateValue(World.class, (Object)event.getWorld(), (String[])new String[]{"eventListeners", "field_73021_x"});
            if (listeners.stream().noneMatch(el -> el instanceof RenderGlobalWrapper)) {
                event.getWorld().func_72954_a((IWorldEventListener)new RenderGlobalWrapper(event.getWorld()));
            }
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        ++this.tickCounter;
        if (this.tickCounter % 20 == 0) {
            this.cleanupExtraDamagedBlocks();
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        damagedBranches.clear();
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        damagedBranches.clear();
    }

    @SubscribeEvent
    public void renderBlockBreakAnim(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        this.drawBlockDamageTexture(mc, textureManager, Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), mc.func_175606_aa(), event.getPartialTicks());
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179084_k();
    }

    private void cleanupExtraDamagedBlocks() {
        Iterator<Map.Entry<Integer, DestroyBlockProgress>> iter = damagedBranches.entrySet().iterator();
        while (iter.hasNext()) {
            DestroyBlockProgress destroyblockprogress = iter.next().getValue();
            int tick = destroyblockprogress.func_82743_f();
            if (this.tickCounter - tick <= 400) continue;
            iter.remove();
        }
    }

    public void sendThickBranchBreakProgress(int breakerId, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            DestroyBlockProgress destroyblockprogress = damagedBranches.get(breakerId);
            if (destroyblockprogress == null || destroyblockprogress.func_180246_b().func_177958_n() != pos.func_177958_n() || destroyblockprogress.func_180246_b().func_177956_o() != pos.func_177956_o() || destroyblockprogress.func_180246_b().func_177952_p() != pos.func_177952_p()) {
                destroyblockprogress = new DestroyBlockProgress(breakerId, pos);
                damagedBranches.put(breakerId, destroyblockprogress);
            }
            destroyblockprogress.func_73107_a(progress);
            destroyblockprogress.func_82744_b(this.tickCounter);
        } else {
            damagedBranches.remove(breakerId);
        }
    }

    private void preRenderDamagedBlocks() {
        try {
            preRenderMethod.invoke((Object)Minecraft.func_71410_x().field_71438_f, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void postRenderDamagedBlocks() {
        try {
            postRenderMethod.invoke((Object)Minecraft.func_71410_x().field_71438_f, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawBlockDamageTexture(Minecraft mc, TextureManager renderEngine, Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, Entity entityIn, float partialTicks) {
        double posX = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double posY = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double posZ = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        if (!damagedBranches.isEmpty()) {
            renderEngine.func_110577_a(TextureMap.field_110575_b);
            this.preRenderDamagedBlocks();
            bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bufferBuilderIn.func_178969_c(-posX, -posY, -posZ);
            bufferBuilderIn.func_78914_f();
            Iterator<Map.Entry<Integer, DestroyBlockProgress>> iter = damagedBranches.entrySet().iterator();
            while (iter.hasNext()) {
                double delZ;
                double delY;
                Map.Entry<Integer, DestroyBlockProgress> entry = iter.next();
                DestroyBlockProgress destroyblockprogress = entry.getValue();
                BlockPos pos = destroyblockprogress.func_180246_b();
                double delX = (double)pos.func_177958_n() - posX;
                if (delX * delX + (delY = (double)pos.func_177956_o() - posY) * delY + (delZ = (double)pos.func_177952_p() - posZ) * delZ > 4096.0) {
                    iter.remove();
                    continue;
                }
                IBlockState state = mc.field_71441_e.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockBranch) {
                    int k1 = destroyblockprogress.func_73106_e();
                    TextureAtlasSprite textureatlassprite = this.destroyBlockIcons[k1];
                    BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
                    if (state.func_185901_i() != EnumBlockRenderType.MODEL) continue;
                    state = state.func_185899_b((IBlockAccess)mc.field_71441_e, pos);
                    IBakedModel baseModel = blockrendererdispatcher.func_175023_a().func_178125_b(state);
                    IBakedModel damageModel = this.getDamageModel(baseModel, textureatlassprite, state, (IBlockAccess)mc.field_71441_e, pos);
                    blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)mc.field_71441_e, damageModel, state, pos, bufferBuilderIn, true);
                    continue;
                }
                iter.remove();
            }
            tessellatorIn.func_78381_a();
            bufferBuilderIn.func_178969_c(0.0, 0.0, 0.0);
            this.postRenderDamagedBlocks();
        }
    }

    private IBakedModel getDamageModel(IBakedModel baseModel, TextureAtlasSprite texture, IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177230_c().getExtendedState(state, world, pos);
        if (baseModel instanceof ICustomDamageModel) {
            ICustomDamageModel customDamageModel = (ICustomDamageModel)baseModel;
            long rand = MathHelper.func_180186_a((Vec3i)pos);
            ArrayList generalQuads = Lists.newArrayList();
            EnumMap faceQuads = Maps.newEnumMap(EnumFacing.class);
            for (EnumFacing facing : EnumFacing.values()) {
                ArrayList quadList = Lists.newArrayList();
                for (BakedQuad quad : customDamageModel.getCustomDamageQuads(state, facing, rand)) {
                    quadList.add(new BakedQuadRetextured(quad, texture));
                }
                faceQuads.put(facing, quadList);
            }
            for (BakedQuad quad : customDamageModel.getCustomDamageQuads(state, null, rand)) {
                generalQuads.add(new BakedQuadRetextured(quad, texture));
            }
            return new SimpleBakedModel((List)generalQuads, (Map)faceQuads, baseModel.isAmbientOcclusion(state), baseModel.func_177556_c(), baseModel.func_177554_e(), baseModel.func_177552_f(), baseModel.func_188617_f());
        }
        return new SimpleBakedModel.Builder(state, baseModel, texture, pos).func_177645_b();
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
            for (int i = 0; i < this.destroyBlockIcons.length; ++i) {
                this.destroyBlockIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);
            }
        }
    }

    static {
        preRenderMethod.setAccessible(true);
        postRenderMethod = ReflectionHelper.findMethod(RenderGlobal.class, (String)"postRenderDamagedBlocks", (String)"func_174969_t", (Class[])new Class[0]);
        postRenderMethod.setAccessible(true);
    }

    private static class RenderGlobalWrapper
    implements IWorldEventListener {
        private final World world;

        public RenderGlobalWrapper(World world) {
            this.world = world;
        }

        public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            Minecraft.func_71410_x().field_71438_f.func_184376_a(worldIn, pos, oldState, newState, flags);
        }

        public void func_174959_b(BlockPos pos) {
            Minecraft.func_71410_x().field_71438_f.func_174959_b(pos);
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
            Minecraft.func_71410_x().field_71438_f.func_147585_a(x1, y1, z1, x2, y2, z2);
        }

        public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
            Minecraft.func_71410_x().field_71438_f.func_184375_a(player, soundIn, category, x, y, z, volume, pitch);
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
            Minecraft.func_71410_x().field_71438_f.func_184377_a(soundIn, pos);
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
            Minecraft.func_71410_x().field_71438_f.func_180442_a(particleID, ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
            Minecraft.func_71410_x().field_71438_f.func_190570_a(id, ignoreRange, p_190570_3_, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
        }

        public void func_72703_a(Entity entityIn) {
            Minecraft.func_71410_x().field_71438_f.func_72703_a(entityIn);
        }

        public void func_72709_b(Entity entityIn) {
            Minecraft.func_71410_x().field_71438_f.func_72709_b(entityIn);
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
            Minecraft.func_71410_x().field_71438_f.func_180440_a(soundID, pos, data);
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
            Minecraft.func_71410_x().field_71438_f.func_180439_a(player, type, blockPosIn, data);
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
            IBlockState state = this.world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockBranchThick) {
                instance.sendThickBranchBreakProgress(breakerId, pos, progress);
            } else {
                Minecraft.func_71410_x().field_71438_f.func_180441_b(breakerId, pos, progress);
            }
        }
    }
}

